    NAME AutoDrvr

; This is AutoDrvr.Asm

; This is the link between InteGRiD & the 640x400 & the 640x200 screen drivers

CGROUP GROUP CODE

videoInt EQU 10H

setVideo EQU 0
getVideo EQU 15


CODE SEGMENT PUBLIC 'CODE'
  ASSUME CS:CGROUP

;
;  Every screen driver "link" must begin with some executable code that
;  ultimately returns the length of the screen driver and its relative
;  offset within the file (relative to the beginning of the screen driver
;  from InteGRiD's point of view.  By convention I am going to always begin
;  these screen driver "link"s with a short jump instruction followed by the
;  offsets within the file and lengths of each actual driver.  This is to
;  make it easier to have one program that builds these drivers.
;
;  Upon Exit
;    BX = length of screen driver (in 16 byte paragraphs)
;    DX = relative offset of beginning of screen driver
;
;    If BX = 0 then there is not an acceptable display for this driver
;

;
;  Screen Driver 1 (1st in file) is the 640x200 driver
;  Screen Driver 2 (2nd in file) is the 640x400 driver, AT&T mode
;

FirstInstruction:
  JMP  SHORT ActualCode

scrDrvrLinkID  DW ?

scrDrvrLength1 DW ?
scrDrvrOffset1 DW ?
scrDrvrLength2 DW ?
scrDrvrOffset2 DW ?

sPartNumber EQU 0FDFDH
twoDashes   EQU 02D2DH
dashOffset  EQU 12

ActualCode:
  MOV		AX, sPartNumber
  MOV  ES, AX
  MOV  BX, dashOffset
  MOV  AX, ES:[BX]
  CMP  AX, twoDashes
  JNE  UseScreenDriver1

  MOV  AL, 40H
  CALL TryThisDriver
  JE   UseScreenDriver2

  MOV  AL, 6
  CALL TryThisDriver

UseScreenDriver1:
  MOV  BX, CS:scrDrvrLength1
  MOV  DX, CS:scrDrvrOffset1
  JMP  SHORT LongReturnExit

UseScreenDriver2:
  MOV  BX, CS:scrDrvrLength2
  MOV  DX, CS:scrDrvrOffset2

LongReturn PROC FAR
LongReturnExit:
  RET
LongReturn ENDP


TryThisDriver PROC NEAR
  PUSH AX
  PUSH BP
  MOV  AH, setVideo
  INT  videoInt
  MOV  AH, getVideo
  INT  videoInt
  POP  BP
  POP  DX
  CMP  AL, DL
  RET
TryThisDriver ENDP


CODE ENDS

    END FirstInstruction
